/* BOLTDatabase.h

	Data Access Classes for BOLT

  */
#ifndef BOLTDB_INCLUDE
#define BOLTDB_INCLUDE "YEAH MOTHERFUCKER"
typedef void * QRY_ID;
typedef unsigned long RECORD_ID;
typedef RECORD_ID RECORDID;
class BOLTdbVars;

class BOLTdb {
public:
	RECORD_ID GetUValue(const char *table, const char *field, RECORD_ID recordID);
	void freePtr(void **ptr);
	void Flush();
	void FetchBinaryResults(QRY_ID qry,const void *row,int field, void **ptr,unsigned long * size);
	unsigned int FetchNumCols(QRY_ID qry,void *row);
	unsigned long FetchNumRows(QRY_ID qry);
	BOLTdb(const char *host,const char *db,
		const char *user,const char *pass,unsigned int port);
	~BOLTdb();
	bool		Disconnect();
	bool		IsError();
	char *		GetError();
	bool		Connected();
	RECORD_ID	NewRecord(const char *table);
	RECORD_ID	NewRecord(const char *table,RECORD_ID id);
	char *		GetQueryValue(const char *qry);
	void GetBinaryQueryValue(const char *qry,void **ptr,unsigned long & length);
	char 		*GetValue(const char *table,const char *field,
				unsigned long recordID);
	double GetFValue(const char *table,const char *field,
				unsigned long recordID);
	long GetIValue(const char *table,const char *field,
				unsigned long recordID);
	bool 		SetValue(const char *table,const char *field,
				 RECORD_ID recordID,const char *value);
	bool		SetBinaryValue(const char *table,const char *field,
				 RECORD_ID recordID,const char *value,unsigned long size);
	bool 		SetValue(const char *table,const char *field,
				 RECORD_ID recordID,double value);
	bool 		SetValue(const char *table,const char *field,
				 RECORD_ID recordID,RECORD_ID value);
	QRY_ID		Query(const char *qry,long length);
	char		*FetchQueryResult(QRY_ID qry,void *row,int field);
	void		*FetchRow(QRY_ID);
	void		FreeQuery(QRY_ID);
	char		*EscapeString(const char* str);

private:
	BOLTdbVars *vars;
	bool connected;
	char *tRes;
};

BOLTdb* createBOLTdb(const char *host,const char *db,
					 const char *user,const char *pass,
					 unsigned int port);
void deleteBOLTdb(BOLTdb** db);
#endif